% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_MultiDataSet-ClassGenerics.R
\name{add_table}
\alias{add_table}
\title{Method to add a \code{matrix} to \code{MultiDataSet}.}
\usage{
add_table(
  object,
  set,
  dataset.type,
  dataset.name = NULL,
  warnings = TRUE,
  overwrite = FALSE
)
}
\arguments{
\item{object}{\code{MultiDataSet} that will be filled.}

\item{set}{\code{matrix} used to fill the slot.}

\item{dataset.type}{Character with the type of data}

\item{dataset.name}{Character with the specific name for this set (NULL by 
default). It is useful when there are several sets of the same type.}

\item{warnings}{Logical to indicate if warnings will be displayed.}

\item{overwrite}{Logical to indicate if the set stored in the slot will be overwritten.}
}
\value{
A new \code{MultiDataSet} with a slot filled.
}
\description{
This method adds or overwrites a slot of a \code{MultiDataSet} with the content 
of the given \code{matrix}.
}
\examples{
multi <- createMultiDataSet()
mat <- matrix(runif(12), nrow = 3)
colnames(mat) <- paste0("S", 1:4)
rownames(mat) <- paste0("F", 1:3)
multi <- add_table(multi, mat, "exampledata")
}
