% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_MultiDataSet-ClassGenerics.R
\name{add_methy}
\alias{add_methy}
\title{Method to add a slot of methylation to \code{MultiDataSet}.}
\usage{
add_methy(object, methySet, ...)
}
\arguments{
\item{object}{\code{MultiDataSet} that will be filled.}

\item{methySet}{\code{MethylationSet} or \code{RatioSet} to be used to fill the slot.}

\item{...}{Further arguments to be passed to \code{add_eset}.}
}
\value{
A new \code{MultiDataSet} with the slot \code{"methylation"}
filled.
}
\description{
This method adds or overwrites the slot \code{"methylation"} of an
\code{MultiDataSet} with the content of the given \code{MethylationSet} or \code{RatioSet}. 
The fData of the input object must contain the columns chromosome and position.
}
\examples{
if (require(brgedata)){
 multi <- createMultiDataSet()
 multi <- add_methy(multi, brge_methy[1:100, ])
}
}
