% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ResultSet-ClassGenerics.R,
%   R/ResultSet-fData.R, R/ResultSet-getAssociation.R, R/ResultSet-length.R,
%   R/ResultSet-names.R, R/ResultSet-opt.R, R/ResultSet-plot.R,
%   R/ResultSet-varLabels.R, R/create_resultset.R
\docType{class}
\name{ResultSet}
\alias{ResultSet}
\alias{ResultSet-class}
\alias{fData,ResultSet-method}
\alias{getAssociation,ResultSet-method}
\alias{length,ResultSet-method}
\alias{names,ResultSet-method}
\alias{opt,ResultSet-method}
\alias{plot,ResultSet,ANY-method}
\alias{varLabels,ResultSet-method}
\alias{create_resultset}
\alias{ResultSet-methods}
\title{Class ResultSet}
\usage{
\S4method{fData}{ResultSet}(object)

\S4method{getAssociation}{ResultSet}(object, rid = 1, coef = 2, contrast = NULL, fNames = NULL, ...)

\S4method{length}{ResultSet}(x)

\S4method{names}{ResultSet}(x)

\S4method{opt}{ResultSet}(object)

\S4method{plot}{ResultSet,ANY}(
  x,
  y,
  rid = 1,
  coef = 2,
  contrast = NULL,
  type,
  tFC = 2,
  tPV = -log10(0.001),
  show.labels = TRUE,
  show.effect = FALSE,
  show.lambda = TRUE,
  fNames = c("chromosome", "start"),
  subset,
  highlight,
  ...
)

\S4method{varLabels}{ResultSet}(object)

create_resultset(fOrigin, lResults, fData, lOptions = list())
}
\arguments{
\item{object}{A \code{ResultSet} object.}

\item{rid}{Name or index of the internal result to be used}

\item{coef}{Coefficient to be returne, usually 2}

\item{contrast}{Numeric matrix with the contrasts used to perform the analyses}

\item{fNames}{Character vector with the names of the fData columns that will 
be added to the results data.frame.}

\item{...}{Further arguments passed to \link[limma]{topTable}}

\item{x}{A \code{ResultSet} object.}

\item{y}{-}

\item{type}{Type of plot to be drawn}

\item{tFC}{Threshold for log FC of effect}

\item{tPV}{Threshold for P-Value}

\item{show.labels}{(default \code{TRUE}) If set to \code{TRUE}, features are 
labelled.}

\item{show.effect}{(default: \code{TRUE}). Used in volcano plot. If \code{TRUE}, 
effect is shown as FC instead of logFC.}

\item{show.lambda}{(default: \code{TRUE}) If \code{TRUE} shows lambda
score for the given model.}

\item{subset}{GenomicRanges used to zoom a region in Manhattan plot}

\item{highlight}{GenomicRanges used to highlight a region in Manhattan plot}

\item{fOrigin}{Chracter with the function used to run the analysis.}

\item{lResults}{List with the results}

\item{fData}{List with the feature data.}

\item{lOptions}{List with additional options}
}
\value{
An object of class \code{ResultSet}
}
\description{
Class \code{ResultSet} used to encapsulate results from \code{MEAL} and 
\code{omicrexposome}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{fData}: Returns \code{data.frame} with feature's data.

\item \code{getAssociation}: Getter to obtain the raw \code{data.frame} from
association and integration analysis.

\item \code{length}: Returns the amoung of analyses stored in the
\code{ResultSet}.

\item \code{names}: Returns the names of the omics data used to create
the \code{ResultSet}.

\item \code{opt}: Returns a list with the options used to create the
\code{ResultSet}

\item \code{plot}: Allows to plot a series of plots (QQ plot, Manhattan
plot and Volcano plot) depending on the results stored in the
\code{ResultSet}.

\item \code{varLabels}: Returns the names of the variables of the models used in
a \code{ResultSet}.
}}

\section{Slots}{

\describe{
\item{\code{fun_origin}}{Character containing the function that creates the object.}

\item{\code{results}}{List containing the results of the association/integration.}

\item{\code{fData}}{List containing the feature-data of the original objects.}

\item{\code{options}}{list of options used to create the \code{ResultSet}.}
}}

\examples{
create_resultset("hello", list(), list(), list())
}
