% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_Spectra_metrics.R
\name{areaUnderTicRtQuantiles}
\alias{areaUnderTicRtQuantiles}
\title{area under TIC RT quantiles (MS:4000156)}
\usage{
areaUnderTicRtQuantiles(spectra, msLevel = 1L, ...)
}
\arguments{
\item{spectra}{\code{Spectra} object}

\item{msLevel}{\code{integer}}

\item{...}{not used here}
}
\value{
\code{.numeric(4)}
}
\description{
MS:4000156 \cr
"The area under the total ion chromatogram of the retention time quantiles. 
Number of quantiles are given by the n-tuple." [PSI:MS] \cr

The metric is calculated as follows: \cr
(1) the \code{Spectra} object is filtered according to the MS level, \cr 
(2) the \code{Spectra} object is ordered according to the retention time, \cr 
(3) the 0\%, 25\%, 50\%, 75\%, and 100\% quantiles of the retention time 
values are obtained, \cr 
(4) the ion count of the intervals between the 0\%/25\%, 25\%/50\%, 
50\%/75\%, and 75\%/100\% are obtained, \cr 
(5) the ion counts of the intervals are summed (TIC) and the values returned.
}
\details{
MS:4000156 \cr
is_a: MS:4000004 ! n-tuple \cr
is_a: MS:4000009 ! ID free \cr
is_a: MS:4000017 ! chromatogram metric \cr

The sum of the TIC is returned as an equivalent to the area. \cr
}
\note{
This function interprets the *quantiles* from the [PSI:MS] definition as
*quartiles*, i.e. the 0, 25, 50, 75 and 100\% quantiles are used.
}
\examples{
library(S4Vectors)
library(Spectra)

spd <- DataFrame(
    msLevel = c(2L, 2L, 2L),
    polarity = c(1L, 1L, 1L),
    id = c("HMDB0000001", "HMDB0000001", "HMDB0001847"),
    name = c("1-Methylhistidine", "1-Methylhistidine", "Caffeine"))
## Assign m/z and intensity values
spd$mz <- list(
    c(109.2, 124.2, 124.5, 170.16, 170.52),
    c(83.1, 96.12, 97.14, 109.14, 124.08, 125.1, 170.16),
    c(56.0494, 69.0447, 83.0603, 109.0395, 110.0712,
        111.0551, 123.0429, 138.0662, 195.0876))
spd$intensity <- list(
    c(3.407, 47.494, 3.094, 100.0, 13.240),
    c(6.685, 4.381, 3.022, 16.708, 100.0, 4.565, 40.643),
    c(0.459, 2.585, 2.446, 0.508, 8.968, 0.524, 0.974, 100.0, 40.994))
spd$rtime <- c(9.44, 9.44, 15.84)
sps <- Spectra(spd)
areaUnderTicRtQuantiles(spectra = sps, msLevel = 2L)
}
\author{
Thomas Naake
}
