% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsExperiment-functions.R
\name{readMsExperiment}
\alias{readMsExperiment}
\title{Import MS spectra data of an experiment}
\usage{
readMsExperiment(spectraFiles = character(), sampleData = data.frame(), ...)
}
\arguments{
\item{spectraFiles}{\code{character} with the (absolute) file names of the MS
data files that should be imported as a \code{\link[Spectra:Spectra]{Spectra::Spectra()}} object.}

\item{sampleData}{\code{data.frame} or \code{DataFrame} with the sample annotations.
Each row is expected to contain annotations for one file (sample). The
order of the data frame's rows is expected to match the order of the
provided files (with parameter \code{spectraFiles}).}

\item{...}{additional parameters for the \code{\link[Spectra:Spectra]{Spectra::Spectra()}} call to
import the data.}
}
\value{
\code{MsExperiment}.
}
\description{
Read/import MS spectra data of an experiment from the respective (raw)
data files into an \code{\link[=MsExperiment]{MsExperiment()}} object. Files provided with the
\code{spectraFiles} parameter are imported as a \code{Spectra} object and each
file is automatically \emph{linked} to rows (samples) of a \code{sampleData}
data frame (if provided).
}
\examples{

## Define the files of the experiment to import
fls <- c(system.file("microtofq/MM14.mzML", package = "msdata"),
         system.file("microtofq/MM8.mzML", package = "msdata"))

## Define a data frame with some sample annotations
ann <- data.frame(
    injection_index = 1:2,
    sample_id = c("MM14", "MM8"))

## Import the data
library(MsExperiment)
mse <- readMsExperiment(spectraFiles = fls, ann)
mse

## Access the spectra data
spectra(mse)

## Access the sample annotations
sampleData(mse)

## Import the data reading all MS spectra directly into memory
mse <- readMsExperiment(spectraFiles = fls, ann,
    backend = Spectra::MsBackendMemory())
mse
}
\author{
Johannes Rainer
}
