% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.R
\name{reduce}
\alias{reduce}
\title{Reduce overlapping numeric ranges to disjoined ranges}
\usage{
reduce(start = numeric(), end = numeric(), .check = TRUE)
}
\arguments{
\item{start}{\code{numeric} with the lower (start) values for each numeric range.}

\item{end}{\code{numeric} with the upper (end) values for each numeric range.
Has to match the length of \code{start} and \code{all(start <= end)} has to be
\code{TRUE}.}

\item{.check}{\code{logical(1)} whether input parameter validations should be
performed. With \code{.check = TRUE} (the default) the function checks if
the length of input parameters \code{start} and \code{end} is the same and whether
all values in \code{start} are \code{<=} the values in \code{end}.}
}
\value{
\code{list} of length 2, the first element being the start (mininum)
values for the disjoint ranges, the second the end (maximum) values.
}
\description{
The \code{reduce()} function \emph{reduces} the provided numeric ranges to
non-overlapping (disjoint) ranges. This is similar to the
\code{IRanges::reduce()} function, but works with \code{numeric} vectors instead of
integer ranges (\code{IRanges}).
}
\note{
The \emph{IRanges} package defines a \code{reduce()} method for \code{IRanges} and other
S4 classes. This \code{reduce()} function is not an S4 method, but a function,
thus it is suggested to specifically import it if used in another R package,
or to call it with \code{MsCoreUtils::reduce()}.
}
\examples{

## Define start and end values for the numeric ranges
s <- c(12.23, 21.2, 13.4, 14.2, 15.0, 43.12)
e <- c(12.40, 24.1, 14.4, 16.2, 15.2, 55.23)

reduce(s, e)

## Empty vectors
reduce()

## Single value
reduce(3.12, 34)

## Non-overlapping ranges
reduce(c(3, 9), c(4, 19))
}
\author{
Johannes Rainer and Sebastian Gibb
}
