% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finemap.R
\name{finemap}
\alias{finemap}
\title{Finemapping of genetic regions}
\usage{
finemap(
  chr,
  start = NULL,
  end = NULL,
  strain1,
  strain2,
  consequence = NULL,
  impact = NULL,
  thr1 = 0,
  thr2 = 0,
  return_obj = "dataframe"
)
}
\arguments{
\item{chr}{Vector of chromosome names.}

\item{start}{Optional vector of chromosomal start positions of target regions
(GRCm38).}

\item{end}{Optional vector of chromosomal end positions of target regions
(GRCm38).}

\item{strain1}{First strain set with strains from avail_strains().}

\item{strain2}{Second strain set with strains from avail_strains().}

\item{consequence}{Optional vector of consequence types.}

\item{impact}{Optional vector of impact types.}

\item{thr1}{Number discordant strains in strain1. Between 0 and
length(strain1)-1. 0 by default.}

\item{thr2}{Number discordant strains in strain2. Between 0 and
length(strain2)-1. 0 by default.}

\item{return_obj}{The user can choose to get the result to be returned as
data frame ("dataframe") or as a GenomicRanges::GRanges ("granges") object.
Default value is "dataframe".}
}
\value{
Data frame or GenomicRanges::GRanges object containing result data.
}
\description{
Finemapping of genetic regions in 37 inbred mice by taking
advantage of their very high homozygosity rate (>95%). For one ore more
chromosomal regions (GRCm38), this method extracts homozygous SNVs for which
the allele differs between two sets of strains (e.g. case vs controls) and
outputs respective causal SNV/gene candidates.
}
\examples{
geno = finemap("chr1",
    start = 5000000, end = 6000000,
    strain1 = c("C57BL_6J"), strain2 = c(
        "129S1_SvImJ", "129S5SvEvBrd",
        "AKR_J"
    )
)

comment(geno)
}
