% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadMAVISp.R
\name{loadMAVISp}
\alias{loadMAVISp}
\title{loadMAVISp}
\usage{
loadMAVISp(
  mavispDB = NULL,
  proteins_of_interest = NULL,
  mode = "simple",
  ensemble = "md"
)
}
\arguments{
\item{mavispDB}{path to the MAVISp database as a string. The database can be downloaded from an OSF repository (https://osf.io/ufpzm/) and has the following structure.}

\item{proteins_of_interest}{vector containing specific proteins of interest in HUGO format}

\item{mode}{string determining whether to use simple or ensemble mode of mavisp. Default is simple mode.
Takes values: 
\itemize{
\item simple
\item ensemble
}}

\item{ensemble}{string specifying the ensemble to use. The available ensembles  can be found in the MAVISp database. This is ignored for simple mode.}
}
\value{
returns a list of tibbles each containing the MAVISp entry of one protein. Each entry will contain an extra column specifying what data
the stability classification is based on.
}
\description{
This function loads the MAVISp database from the directory specified by the user.
}
\examples{

mavisp_db_location <- system.file('extdata', 'mavisp_db', package='Moonlight2R')

mavisp_data <- loadMAVISp(mavispDB = mavisp_db_location,
                          proteins_of_interest = c('TP53'),
                          mode = 'ensemble')

}
