% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBoundaries.R
\name{readBoundaries}
\alias{readBoundaries}
\title{Read in csv boundary information and convert to ME list format.}
\usage{
readBoundaries(
  dataDir,
  pattern = NULL,
  segmentIDCol = NULL,
  xCol = NULL,
  yCol = NULL,
  keepCols = "essential",
  boundariesAssay = NULL,
  scaleFactorVector = 1
)
}
\arguments{
\item{dataDir}{Path of the directory containing the boundary csv files.}

\item{pattern}{Character string specifying the unique pattern with which to
identify the files of interest in the directory. This is useful to work with
multiple samples. Defaults to NULL.}

\item{segmentIDCol}{Character string specifying the name of the column
containing the segment IDs. Defaults to NULL.}

\item{xCol}{Character string specifying the name of the column containing
the x coordinates of the vertices defining the boundaries. Defaults to NULL.}

\item{yCol}{Character string specifying the name of the column containing
the y coordinates of the vertices defining the boundaries. Defaults to NULL.}

\item{keepCols}{Character string specifying which columns to keep.
Defaults to "essential". The other option is to select "all", or custom
columns by specifying their names in a vector.}

\item{boundariesAssay}{Character string specifying the name with which to
identify the boundary data in the ME object later on. Defaults to NULL.}

\item{scaleFactorVector}{Vector containing the scale factor/s with which to
change the coordinate data from pixel to micron. It can be either a single
integer, or multiple scale factors for the different samples. The default
value is 1.}
}
\value{
An ME list containing the boundary information. This can be used as
input to the boundaries slot of an ME object.
}
\description{
This function reads in csv boundary files and converts them to the ME list
format, so that they can be added to an ME object later on. To account for
different coordinate scales possible being used by the boundary versus
transcript information, this function scales the coordinate values of the
boundaries to match the unit of the detected transcript locations.
The various arguments offer flexibility to standardise data from different
molecule-based ST technologies into the ME list format.
}
\examples{
repoDir <- system.file("extdata", package = "MoleculeExperiment")
repoDir <- paste0(repoDir, "/xenium_V1_FF_Mouse_Brain")
nucleiMEList <- readBoundaries(dataDir = repoDir,
                            pattern = "nucleus_boundaries.csv",
                            segmentIDCol = "cell_id",
                            xCol = "vertex_x",
                            yCol = "vertex_y",
                            keepCols = "essential",
                            boundariesAssay = "nucleus",
                            scaleFactorVector = 1)
nucleiMEList
}
