% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countMolecules.R
\name{countMolecules}
\alias{countMolecules}
\title{Count molecules per region of interest (e.g., cell)}
\usage{
countMolecules(
  me,
  moleculesAssay = "detected",
  boundariesAssay = "cell",
  buffer = 0,
  matrixOnly = FALSE,
  nCores = 1
)
}
\arguments{
\item{me}{MoleculeExperiment object containing both the transcript data
as well as the boundaries data. I.e., the "molecules" and "boundaries" slots
need to be filled. See MoleculeExperiment() for more information.}

\item{moleculesAssay}{Character string naming the list of the molecules slot
from which transcript information should be retrieved from.
The default is the detected transcript data that is read in when creating a
MoleculeExperiment object. It is possible to change it to another mode, e.g.,
"high_threshold" will access the transcript information that has been stored
in the "high_threshold" element of the list in the molecules slot.}

\item{boundariesAssay}{Character string naming the list of the boundaries
slot from which boundary information should be retrieved from.
For example, for counting transcripts per cell, the list containing the cell
boundaries (e.g., "cell") should be selected.}

\item{buffer}{Single numeric value (default 0) indicating value to buffer
beyond segment boundaries, i.e. to count molecules just outside of a segment
boundary}

\item{matrixOnly}{Logical value indicating whether to return a matrix of the
counted molecules per segment (e.g., cell). Is FALSE by default, i.e., the
default output is a SpatialExperiment object.}

\item{nCores}{Number of cores to use for the operation.}
}
\value{
A SpatialExperiment object derived from a MoleculeExperiment object.
Alternatively, a matrix with the counted molecules per segment.
}
\description{
This function takes the information from the molecules and boundaries slot,
and counts the molecules per region of interest. Its input is a
MoleculeExperiment object, and its output a SpatialExperiment object.
That way, if one is interested in doing downstream analyses at the cell
level, one can do so.
}
\examples{
repoDir <- system.file("extdata", package = "MoleculeExperiment")
repoDir <- paste0(repoDir, "/xenium_V1_FF_Mouse_Brain")
me <- readXenium(repoDir,
    keepCols = "essential"
)

spe <- countMolecules(me)
spe
}
