% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{mp_plot_alpha}
\alias{mp_plot_alpha}
\alias{mp_plot_alpha,MPSE-method}
\alias{mp_plot_alpha,MPSE}
\alias{mp_plot_alpha,tbl_mpse-method}
\alias{mp_plot_alpha,tbl_mpse}
\alias{mp_plot_alpha,grouped_df_mpse-method}
\alias{mp_plot_alpha,grouped_df_mpse}
\title{Plotting the alpha diversity between samples or groups.}
\usage{
mp_plot_alpha(
  .data,
  .group,
  .alpha = c("Observe", "Shannon"),
  test = "wilcox.test",
  comparisons = NULL,
  step_increase = 0.05,
  ...
)

\S4method{mp_plot_alpha}{MPSE}(
  .data,
  .group,
  .alpha = c("Observe", "Shannon"),
  test = "wilcox.test",
  comparisons = NULL,
  step_increase = 0.05,
  ...
)

\S4method{mp_plot_alpha}{tbl_mpse}(
  .data,
  .group,
  .alpha = c("Observe", "Shannon"),
  test = "wilcox.test",
  comparisons = NULL,
  step_increase = 0.05,
  ...
)

\S4method{mp_plot_alpha}{grouped_df_mpse}(
  .data,
  .group,
  .alpha = c("Observe", "Shannon"),
  test = "wilcox.test",
  comparisons = NULL,
  step_increase = 0.05,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.group}{the column name of sample group information}

\item{.alpha}{the column name of alpha index after run mp_cal_alpha or mp_cal_pd_metric.}

\item{test}{the name of the statistical test, default is 'wilcox.test'}

\item{comparisons}{A list of length-2 vectors. The entries in the vector are
either the names of 2 values on the x-axis or the 2 integers that 
correspond to the index of the columns of interest, default is NULL, meaning 
it will be calculated automatically with the names in the .group.}

\item{step_increase}{numeric vector with the increase in fraction of total
height for every additional comparison to minimize overlap, default is 0.05.}

\item{...}{additional parameters, see also \code{\link[ggsignif]{geom_signif}}}
}
\description{
Plotting the alpha diversity between samples or groups.
}
\examples{
\dontrun{
data(mouse.time.mpse)
mpse <- mouse.time.mpse \%>\%
        mp_rrarefy() \%>\%
        mp_cal_alpha(.abundance=RareAbundance)
mpse
p <- mpse \%>\% 
     mp_plot_alpha(.group=time, .alpha=c(Observe, Shannon, Pielou))
p
}
}
\author{
Shuangbin Xu
}
