% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichMDA.R
\name{enrichMDA}
\alias{enrichMDA}
\title{Microbe-Disease associations enrichment analysis}
\usage{
enrichMDA(
  microbe_list,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe,
  minGSSize = 10,
  maxGSSize = 500,
  qvalueCutoff = 0.2
)
}
\arguments{
\item{microbe_list}{a vector of microbe ncbi tax ids.}

\item{pvalueCutoff}{adjusted pvalue cutoff on enrichment tests to report.}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni",
"BH", "BY", "fdr", "none".}

\item{universe}{universe background genes. If missing, use disbiome as
default.}

\item{minGSSize}{minimal size of genes annotated by KEGG term for testing.}

\item{maxGSSize}{maximal size of genes annotated for testing.}

\item{qvalueCutoff}{qvalue cutoff on enrichment tests to report.}
}
\value{
A \code{enrichResult} instance.
}
\description{
Microbe-Disease associations enrichment analysis
}
\examples{

data(microbiota_taxlist)
mda <- enrichMDA(microbiota_taxlist)
head(mda)

}
