% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Download_Preprocess.R
\name{Preprocess_DNAmethylation}
\alias{Preprocess_DNAmethylation}
\title{The Preprocess_DNAmethylation function}
\usage{
Preprocess_DNAmethylation(CancerSite, METdirectories,
  MissingValueThreshold = 0.2)
}
\arguments{
\item{CancerSite}{character of length 1 with TCGA cancer code.}

\item{METdirectories}{character vector with directories with the downloaded data. It can be the object returned by the Download_DNAmethylation function.}

\item{MissingValueThreshold}{threshold for removing samples or genes with missing values.}
}
\value{
List with the pre-processed data matrix for cancer and normal samples.
}
\description{
Pre-processes DNA methylation data from TCGA.
}
\details{
Pre-process includes eliminating samples and genes with too many NAs, imputing NAs, and doing Batch correction.
If there is both 27k and 450k data, and both data sets have more than 50 samples, we combine the data sets, by reducing the 450k data to the probes present in the 27k data, and bath correction is performed again to the combined data set.
If there are samples with both 27k and 450k data, the 450k data is used and the 27k data is discarded, before the step mentioned above.
If the 27k or the 450k data does not have more than 50 samples, we use the one with the greatest number of samples, we do not combine the data sets.
}
\examples{
\dontrun{

# Optional register cluster to run in parallel
library(doParallel)
cl <- makeCluster(5)
registerDoParallel(cl)

# Methylation data for ovarian cancer
cancerSite <- "OV"
targetDirectory <- paste0(getwd(), "/")

# Downloading methylation data
METdirectories <- Download_DNAmethylation(cancerSite, targetDirectory, TRUE)

# Processing methylation data
METProcessedData <- Preprocess_DNAmethylation(cancerSite, METdirectories)

# Saving methylation processed data
saveRDS(METProcessedData, file = paste0(targetDirectory, "MET_", cancerSite, "_Processed.rds"))

# Clustering methylation data
res <- ClusterProbes(METProcessedData[[1]], METProcessedData[[2]])

# Saving methylation clustered data
toSave <- list(METcancer = res[[1]], METnormal = res[[2]], ProbeMapping = res$ProbeMapping)
saveRDS(toSave, file = paste0(targetDirectory, "MET_", cancerSite, "_Clustered.rds"))

stopCluster(cl)
}

}
\keyword{preprocess}
