% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethylMix.R
\name{MethylMix_ModelGeneExpression}
\alias{MethylMix_ModelGeneExpression}
\title{The MethylMix_ModelGeneExpression function}
\usage{
MethylMix_ModelGeneExpression(METcancer, GEcancer, CovariateData = NULL)
}
\arguments{
\item{METcancer}{matrix with methylation data for cancer samples (genes in rows, samples in columns).}

\item{GEcancer}{matrix with gene expression data for cancer samples (genes in rows, samples in columns).}

\item{CovariateData}{vector (numeric or character) indicating a covariate to be included in the model to adjust for it. Not used in an standard run of MethylMix.
It can be used if samples can from different tissue type, for example.}
}
\value{
vector with the names of the genes for which there is a significant linear and negative association between methylation and gene expression.
}
\description{
Model gene expression as a function of gene expression with a simple linear regression model. 
Genes with a significant negative linear association between DNA methylation and gene expression are returned.
}
\examples{
# load data sets
data(METcancer)
data(GEcancer)

# model gene expression
MethylMixResults <- MethylMix_ModelGeneExpression(METcancer, GEcancer)

}
