% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_promoter_avg.R
\name{get_promoter_avg}
\alias{get_promoter_avg}
\title{Summarize promoter DNA methylation beta values by mean.}
\usage{
get_promoter_avg(
  dnam,
  genome,
  arrayType,
  cores = 1,
  upstream.dist.tss = 2000,
  downstream.dist.tss = 2000,
  verbose = FALSE
)
}
\arguments{
\item{dnam}{A DNA methylation matrix or a SummarizedExperiment object}

\item{genome}{Human genome of reference hg38 or hg19}

\item{arrayType}{DNA methylation array type (450k or EPIC)}

\item{cores}{A integer number to use multiple cores. Default 1 core.}

\item{upstream.dist.tss}{Number of base pairs (bp) upstream of TSS
to consider as promoter regions}

\item{downstream.dist.tss}{Number of base pairs (bp) downstream of TSS
to consider as promoter regions}

\item{verbose}{A logical argument indicating if
messages output should be provided.}
}
\value{
A RangedSummarizedExperiment with promoter region and
mean beta-values of CpGs within it.
Metadata will provide the promoter gene region and gene informations.
}
\description{
First, identify gene promoter regions (default +-2Kkb around TSS).
Then, for each promoter region calculate the mean DNA methylation of probes
overlapping the region.
}
\examples{
\dontrun{
  data("dna.met.chr21")
  promoter.avg <- get_promoter_avg(
     dnam = dna.met.chr21,
     genome = "hg19",
     arrayType = "450k"
)
}
}
