% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_triplet_regulon_based.R
\name{create_triplet_regulon_based}
\alias{create_triplet_regulon_based}
\title{Map TF and target genes using regulon databases or
any user provided target-tf. Maps
TF to the DNAm region with TFBS using JASPAR2020 TFBS.}
\usage{
create_triplet_regulon_based(
  region,
  genome = c("hg38", "hg19"),
  regulons.min.confidence = "B",
  motif.search.window.size = 0,
  motif.search.p.cutoff = 1e-08,
  cores = 1,
  tf.target,
  TF.peaks.gr = NULL,
  max.distance.region.target = 10^6
)
}
\arguments{
\item{region}{A Granges or a named vector with
regions (i.e "chr21:100002-1004000")}

\item{genome}{Human genome reference "hg38" or "hg19"}

\item{regulons.min.confidence}{Minimun confidence score
("A", "B","C","D", "E") classifying regulons based on
their quality from Human DoRothEA database
 \link[dorothea]{dorothea_hs}. The default minimun confidence score is "B".}

\item{motif.search.window.size}{Integer value to extend the regions.
For example, a value of 50 will
extend 25 bp upstream and 25 downstream the region. Default is no increase}

\item{motif.search.p.cutoff}{motifmatchr pvalue cut-off. Default 1e-8.}

\item{cores}{Number of CPU cores to be used. Default 1.}

\item{tf.target}{A dataframe with tf and target columns. If not provided,
\link[dorothea]{dorothea_hs} will be used.}

\item{TF.peaks.gr}{A granges with TF peaks to be overlaped with input region
Metadata column expected "id" with TF name. Default NULL. Note that Remap catalog
can be used as shown in the examples.}

\item{max.distance.region.target}{Max distance between region and target gene.
Default 1Mbp.}
}
\value{
A data frame with TF, target and RegionID information.
}
\description{
This function wraps two other functions
\code{get_region_target_gene} and \code{get_tf_in_region} from the package.
}
\examples{
triplet <- create_triplet_regulon_based(
   region = c("chr1:69591-69592", "chr1:898803-898804"),
   motif.search.window.size = 50,
   regulons.min.confidence = "B",
     motif.search.p.cutoff = 0.05
)
}
