% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowSOM.MC.R
\name{flowSOM.MC}
\alias{flowSOM.MC}
\title{Cluster cytometry data using FlowSOM}
\usage{
flowSOM.MC(fcsFrame, excludeClusterParameters, xdim = 10, ydim = 10,
  k = 40, seed = NULL)
}
\arguments{
\item{fcsFrame}{A flow frame.}

\item{excludeClusterParameters}{A vector specifying the name of markers not
to be used for clustering.}

\item{xdim}{An integer, defines the width of SOM}

\item{ydim}{An integer, defines the height of SOM}

\item{k}{An integer, defines the number of clusters to be identified by
flowSOM.}

\item{seed}{Set seed for reproducible results.}
}
\value{
A list of clusters. Each cluster contains the ID of all cells that
  belong to the cluster.
}
\description{
A function that cluster cytometry data using FlowSOM.
}
\examples{
# Find fcs files
files=system.file("extdata",
                  "SDY420/ResultFiles/CyTOF_result",package="MetaCyto")
files=list.files(files,pattern="fcs$",full.names=TRUE)
# Preprocess
fcs = preprocessing(fcsFiles=files,assay ="CyTOF",b=1/8)
# cluster using flowSOM.MC
cluster_list=flowSOM.MC(fcsFrame=fcs,
                        excludeClusterParameters=c("Time","Cell_length"))
}
