% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_records_class.R
\name{wherever}
\alias{wherever}
\title{Filter helper function to select records}
\usage{
wherever(...)
}
\arguments{
\item{...}{Expressions that return a logical value and are defined in terms
of the columns in the annotation_source. If multiple conditions are
included then they are combined with the \code{&} operator. Only records
for which all conditions evaluate to \code{TRUE} are kept.}
}
\value{
a list of quosures for use with \code{filter_records}
}
\description{
Returns a list of quosures for use with
\code{filter_records} to allow the use of dplyr-style expressions. See examples.
}
\examples{
# some annotation data
AN <- annotation_source(data = iris)

# filter to setosa where Sepal length is less than 5
M <- filter_records(
    wherever(
        Species == "setosa",
        Sepal.Length < 5
    )
)
M <- model_apply(M, AN)
predicted(M) # 20 rows

}
\seealso{
\code{\link[=filter_records]{filter_records()}}
}
