% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_venn_class.R
\name{filter_venn}
\alias{filter_venn}
\title{Filter by factor levels}
\usage{
filter_venn(
  factor_name,
  group_column = NULL,
  tables = NULL,
  filter = NULL,
  mode = "include",
  ...
)
}
\arguments{
\item{factor_name}{(character) The name of the column(s) in the
\code{annotation_source} to generate intersection groups from. Supports
any number of columns for intersection-based filtering.}

\item{group_column}{(character, NULL) The name of the column in the
\code{annotation_source} to create groups from in the Venn diagram. This
parameter is ignored if \code{!is.null(tables)}, as each table is
considered to be a group. This parameter is also ignored if more than
one \code{factor_name} is provided, as each column is considered a group.
The default is \code{NULL}.}

\item{tables}{(list, NULL) A list of \code{annotation_sources} to generate
the venn groups from. If the only table of interest is the table
coming in from \code{model_apply} then set \code{tables = NULL} and use
\code{group_column}. The default is \code{NULL}.}

\item{filter}{(function, NULL) A function to filter intersections
based on their properties. The function should take region_data as
input and return a logical vector indicating which intersections to
keep. Use upset_intersections(), upset_min_size(),
upset_min_groups(), upset_max_groups(), or create custom filter
functions. The default is \code{NULL}.}

\item{mode}{(character) Filter mode. Allowed values are limited to
the following: \itemize{ \item{\code{"include"}: Only items that
appear in the filtered intersections are kept in the
output.}\item{\code{"exclude"}: Items that appear in the filtered
intersections are removed from the output.}} The default is
\code{"include"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{filter_venn} object with the following \code{output}
slots:
\tabular{ll}{
\code{filtered} \tab (annotation_source) Annotation_source after
filtering. \cr
\code{flags} \tab (data.frame) A list of flags indicating which
annotations were removed. \cr
}
}
\description{
Removes (or includes) annotations such that the named
column excludes (or includes) the specified intersection levels.
Supports any number of groups using intersection-based filtering. If
no levels are specified, all available intersection levels will be
returned for inspection. If invalid levels are specified, a warning
will be shown with the list of valid levels.
}
\section{Inheritance}{

A \code{filter_venn} object inherits the following \code{struct} classes:
\cr\cr
\verb{[filter_venn]} -> \verb{[model]} -> \verb{[struct_class]}
}

\examples{
M <- filter_venn(
        factor_name = "V1",
        group_column = NULL,
        tables = NULL,
        filter = NULL,
        mode = "include")

}
