% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyApp.R
\name{select}
\alias{select}
\title{Select variable based on condition}
\usage{
select(condition, mz, rt, clust)
}
\arguments{
\item{condition}{\code{character(1)}, either \code{"mz"},
\code{"retentionTime"}, or \code{"clustering"}}

\item{mz}{object to return if \code{condition == "mz"}}

\item{rt}{object to return if \code{condition == "retentionTime"}}

\item{clust}{object to return if \code{condition == "clustering"}}
}
\value{
\code{mz}, \code{rt} or \code{clust} depending on \code{condition}
}
\description{
\code{select} returns \code{mz}, \code{rt} or \code{clust} depending on
\code{condition}.
}
\details{
Helper function for \code{shinyCircos}, \code{replayPlotOrder} and 
\code{replayPlotAdd}.
}
\examples{
mz <- 1
rt <- 2
clust <- 3
MetCirc:::select(condition = "mz", mz = mz, rt = rt, clust = clust)

}
\author{
Thomas Naake \email{thomasnaake@googlemail.com}
}
