% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{neutralloss}
\alias{neutralloss}
\title{Calculate similarity based on neutral losses}
\usage{
neutralloss(x, y, m = 0.5, n = 2, na.rm = TRUE, ...)
}
\arguments{
\item{x}{\code{Spectra} object from \code{Spectra} containing
intensity and m/z values, first MS/MS spectrum}

\item{y}{\code{Spectra} object from \code{Spectra} containing 
intensity and m/z values, second MS/MS spectrum}

\item{m}{\code{numeric(1)}, exponent to calculate peak intensity-based 
weights}

\item{n}{\code{numeric(1)}, exponent to calculate m/z-based weights}

\item{na.rm}{\code{logical(1)}, if \code{NA} values should be removed}

\item{...}{further arguments}
}
\value{
\code{neutralloss} returns a numeric similarity coefficient between 0 and 1
}
\description{
Calculate similarity based on neutral losses (NLS)
}
\details{
Similarities of spectra based on neutral losses are calculated according to 
the following formula: 

\deqn{NLS = \frac{\sum(W_{S1, i} \cdot W_{S2, i}) ^ 2}{ \sum(W_{S1, i} ^ 2) \cdot \sum(W_{S2, i} ^ 2) }}{\sum(W_{S1, i} \cdot W_{S2, i}) ^ 2 \sum(W_{S1, i} ^ 2) * \sum(W_{S2, i} ^ 2)},

with \eqn{W = [ peak intensity] ^{m} \cdot [ NL ]^n} and 
\eqn{NL = | m/z - precursor m/z |}. For further information 
see Li et al. (2015): Navigating natural variation in herbivory-induced
secondary metabolism in coyote tobacco populations using MS/MS structural 
analysis. PNAS, E4147--E4155. 

In here, the precursor m/z is taken by the m/z feature with the highest 
intensity. 

\code{neutralloss} returns a numeric value ranging between 0 and 1, where 0 
indicates no similarity between the two MS/MS features, while 1 indicates 
that the MS/MS features are identical. 
Prior to calculating \deqn{W_{S1}} or \deqn{W_{S2}}, all intensity values 
are divided by the maximum intensity value.
}
\examples{
data("spectra", package = "MetCirc")
Spectra::compareSpectra(sps_tissue[1:10], FUN = neutralloss, m = 0.5, n = 2)

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
