% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutTrunkBranch.R
\name{mutTrunkBranch}
\alias{mutTrunkBranch}
\title{mutTrunkBranch}
\usage{
mutTrunkBranch(
  phyloTree,
  patient.id = NULL,
  CT = FALSE,
  pvalue = 0.05,
  plot = TRUE
)
}
\arguments{
\item{phyloTree}{phyloTree or phyloTreeList object generated by \code{\link{getPhyloTree}} function.}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included}

\item{CT}{Distinction between C>T at CpG and C>T at other sites. (Default: FALSE).}

\item{pvalue}{Confidence level of the interval for Fisher test. Default 0.05.}

\item{plot}{Logical. (Default: TRUE).}
}
\value{
a list of box plots based on mutational categories
}
\description{
Summarize and conduct paired Fisher test of mutations of trunk/branches in a phylogenetic tree.
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")

## Load a reference genome.
library(BSgenome.Hsapiens.UCSC.hg19)

phyloTree <- getPhyloTree(maf, patient.id = 'V402')
mutTrunkBranch(phyloTree, plot = TRUE)

}
