% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutHeatmap.R
\name{mutHeatmap}
\alias{mutHeatmap}
\title{mutHeatmap}
\usage{
mutHeatmap(
  maf,
  patient.id = NULL,
  min.vaf = 0,
  min.ccf = 0,
  use.adjVAF = FALSE,
  use.ccf = FALSE,
  geneList = NULL,
  plot.geneList = FALSE,
  show.geneList = TRUE,
  mut.threshold = 50,
  sample.text.size = 9,
  legend.title.size = 10,
  gene.text.size = 9,
  sampleOrder = NULL,
  use.tumorSampleLabel = FALSE,
  classByTumor = FALSE,
  ...
)
}
\arguments{
\item{maf}{Maf or MafList object generated by \code{\link{readMaf}} function.}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included.}

\item{min.vaf}{The minimum value of VAF. Default 0. Option: on the scale of 0 to 1.}

\item{min.ccf}{The minimum value of CCF. Default 0. Option: on the scale of 0 to 1.}

\item{use.adjVAF}{Use adjusted VAF in analysis when adjusted VAF or CCF is available. Default FALSE.}

\item{use.ccf}{Logical. If FALSE (Default: FALSE), print a binary heatmap of mutations. 
Otherwise, print a cancer cell frequency (CCF) heatmap.}

\item{geneList}{List of genes to restrict the analysis. Default NULL.}

\item{plot.geneList}{Logical (Default: FALSE). If TRUE, plot heatmap with genes on geneList when geneList is not NULL.}

\item{show.geneList}{Show the names of gene on the geneList. Default TRUE.}

\item{mut.threshold}{show.gene and show.geneList will be FALSE when patient have more mutations than threshold. Default 150.}

\item{sample.text.size}{Size of sample name.Default 9.}

\item{legend.title.size}{Size of legend title.Default 10.}

\item{gene.text.size}{Size of gene text. Default 9.}

\item{sampleOrder}{A named list which contains the sample order used in plotting the heatmap. Default NULL.}

\item{use.tumorSampleLabel}{Logical (Default: FALSE). Rename the 'Tumor_Sample_Barcode' by 'Tumor_Sample_Label'.}

\item{classByTumor}{Logical Default: FALSE. Classify mutations based on "Tumor_ID".}

\item{...}{Other options passed to \code{\link{subMaf}}}
}
\value{
heatmap of somatic mutations
}
\description{
plot binary or CCF heatmap of somatic mutations.
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
mutHeatmap(maf)

}
