% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutCluster.R
\name{mutCluster}
\alias{mutCluster}
\title{mutCluster}
\usage{
mutCluster(
  maf,
  patient.id = NULL,
  use.ccf = FALSE,
  segFile = NULL,
  withinTumor = FALSE,
  use.tumorSampleLabel = FALSE,
  ...
)
}
\arguments{
\item{maf}{Maf or MafList object generated by \code{\link{readMaf}} function.}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included.}

\item{use.ccf}{Cluster CCF. Default FALSE.}

\item{segFile}{The segment file.}

\item{withinTumor}{Cluster Tumor average CCF within tumors in each patients. Default FALSE.}

\item{use.tumorSampleLabel}{Logical (Default: FALSE). 
Rename the 'Tumor_Sample_Barcode' by 'Tumor_Sample_Label'.}

\item{...}{Other options passed to \code{\link{subMaf}}}
}
\value{
clustering plots of vaf
}
\description{
Cluster mutations based on variant allele frequencies (VAFs) or cancer cell fractions (CCFs).
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
mutCluster(maf, patient.id = 'V402')

}
