% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{getPhyloTreeRef}
\alias{getPhyloTreeRef}
\alias{getPhyloTreeRef,phyloTree-method}
\alias{getPhyloTreeTsbLabel,phyloTree-method}
\title{getPhyloTreeRef}
\usage{
getPhyloTreeRef(object)

\S4method{getPhyloTreeRef}{phyloTree}(object)

\S4method{getPhyloTreeTsbLabel}{phyloTree}(object)
}
\arguments{
\item{object}{An object of phyloTree}
}
\value{
Reference genome versions of phyloTree
}
\description{
getPhyloTreeRef
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
phyloTree <- getPhyloTree(maf)
getPhyloTreeRef(phyloTree$V402)
}
