% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPhyloTree.R
\name{getPhyloTree}
\alias{getPhyloTree}
\title{getPhyloTree}
\usage{
getPhyloTree(
  maf,
  patient.id = NULL,
  method = "NJ",
  min.vaf = 0,
  min.ccf = 0,
  bootstrap.rep.num = 100,
  ...
)
}
\arguments{
\item{maf}{Maf or MafList object generated by \code{\link{readMaf}} function}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included.}

\item{method}{Approach to construct phylogenetic trees. 
Choose one of "NJ"(Neibor-Joining), "MP"(maximum parsimony), 
"ML"(maximum likelihood), "FASTME.ols" or "FASTME.bal".}

\item{min.vaf}{The minimum value of vaf. Default 0.}

\item{min.ccf}{The minimum value of CCF. Default 0}

\item{bootstrap.rep.num}{Bootstrap iterations. Default 100.}

\item{...}{Other options passed to \code{\link{subMaf}}}
}
\value{
PhyloTree or phyloTreeList object
}
\description{
getPhyloTree
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
phyloTree <- getPhyloTree(maf)
}
