% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calJSI.R
\name{calJSI}
\alias{calJSI}
\title{compareJSI}
\usage{
calJSI(
  maf,
  patient.id = NULL,
  pairByTumor = FALSE,
  min.ccf = 0,
  plot = FALSE,
  use.circle = TRUE,
  title = NULL,
  number.cex = 8,
  number.col = "#C77960",
  use.tumorSampleLabel = FALSE,
  ...
)
}
\arguments{
\item{maf}{Maf or MafList object generated by \code{\link{readMaf}} function.}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included.}

\item{pairByTumor}{Compare JSI between different tumors. Default FALSE.}

\item{min.ccf}{The minimum value of CCF. Default 0.}

\item{plot}{Logical (Default: FALSE).}

\item{use.circle}{Logical (Default: TRUE). Whether to use "circle" as visualization method of correlation matrix.}

\item{title}{Title of the plot Default "Jaccard similarity".}

\item{number.cex}{The size of text shown in correlation plot. Default 8.}

\item{number.col}{The color of text shown in correlation plot. Default "#C77960".}

\item{use.tumorSampleLabel}{Logical (Default: FALSE). Rename the 'Tumor_Sample_Barcode' by 'Tumor_Sample_Label'.}

\item{...}{Other options passed to \code{\link{subMaf}}}
}
\value{
Correlation matrix and heatmap via Jaccard similarity coefficient method
}
\description{
The Jaccard similarity index (JSI) is applied to distinguish monoclonal versus polyclonal seeding in metastases.
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
calJSI(maf)
}
\references{
Hu, Z., Li, Z., Ma, Z. et al. Multi-cancer analysis of clonality and the timing of systemic spread in paired primary tumors and metastases. Nat Genet (2020).
}
