% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_measuredvalues_missingvalues.R
\name{upsetCategory}
\alias{upsetCategory}
\title{UpSet plot to display measures values across sample types}
\usage{
upsetCategory(se, category = colnames(colData(se)), measured = TRUE)
}
\arguments{
\item{se}{\code{SummarizedExperiment},
 containing the intensity values in \code{assay(se)}, missing values are
encoded by \code{NA}}

\item{category}{\code{character}, corresponding to a column in 
\code{colData(se)}}

\item{measured}{\code{logical}, should the measured values 
(\code{measured = TRUE}) 
or missing values (\code{measured = FALSE}) be taken}
}
\value{
\code{upset} plot
}
\description{
The function \code{upsetCategory} displays the frequency of measured values 
per feature with respect to class/sample type to assess difference in
occurrences. Internally, the measured values per sample are obtained via
the \code{measuredCategory} function: this function will access the number
of measured/missing values per category and feature. From this, a binary 
\code{tbl} will be created specifying if the feature is present/missing, 
which will be given to the \code{upset} function from the \code{UpSetR} 
package.
}
\details{
Presence is defined by a feature being measured in at least one 
sample of a set.

Absence is defined by a feature with only missing values (i.e. 
no measured values) of a set.
}
\examples{
## create se
a <- matrix(seq_len(100), nrow = 10, ncol = 10, 
            dimnames = list(seq_len(10), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
set.seed(1)
a <- a + rnorm(100)
cD <- data.frame(name = colnames(a), type = c(rep("1", 5), rep("2", 5)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment::SummarizedExperiment(assay = a, 
    rowData = rD, colData = cD)

upsetCategory(se, category = "type")

}
