% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{transformAssay}
\alias{transformAssay}
\title{Transform the (count/intensity) values of a \code{data.frame}, 
\code{tbl} or \code{matrix}}
\usage{
transformAssay(
  a,
  method = c("none", "log", "log2", "log10", "vsn"),
  .offset = 1
)
}
\arguments{
\item{a}{\code{matrix} with samples in columns and features in rows}

\item{method}{\code{character}, one of \code{"none"}, \code{"log"}, 
\code{"log2"}, \code{"log10"}, or \code{"vsn"}}

\item{.offset}{\code{numeric(1)}, offset to add when \code{method} set to
\code{"log"}, \code{"log2"}, or \code{"log10"} and 
\code{a} contains values of 0, default to 1}
}
\value{
\code{matrix}
}
\description{
The function \code{transformAssay} transforms the (count/intensity) values 
of a  \code{matrix}. It uses either \code{log}, \code{log2}, \code{log10},  
variance stabilizing normalisation (\code{vsn}) or no transformation method 
(pass-through, \code{none}). The object
\code{x} has the samples in the columns and the features in the rows.
}
\details{
Internal use in \code{shinyQC}.
}
\examples{
a <- matrix(seq_len(1000), nrow = 100, ncol = 10, 
        dimnames = list(seq_len(100), paste("sample", seq_len(10))))
transformAssay(a, "none")
transformAssay(a, "log")
transformAssay(a, "log2")
transformAssay(a, "vsn")

}
