% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_dimensionreduction.R
\name{tblPCALoadings}
\alias{tblPCALoadings}
\title{Return tibble with PCA loadings for features}
\usage{
tblPCALoadings(x, params)
}
\arguments{
\item{x}{\code{matrix}, containing no missing values}

\item{params}{\code{list}, arguments/parameters given to the function 
\code{stats::prcomp}}
}
\value{
\code{tbl}
}
\description{
The function \code{tblPCALoadings} returns a \code{tibble} with loadings 
values for the features (row entries) in \code{x}.
}
\details{
The function \code{tblPCALoadings} acccesses the list entry \code{rotation} 
of the \code{prcomp} object.
}
\examples{
set.seed(1)
x <- matrix(rnorm(seq_len(10000)), ncol = 100)
rownames(x) <- paste("feature", seq_len(nrow(x)))
colnames(x) <- paste("sample", seq_len(ncol(x)))
params <- list(method = "euclidean", ## dist
    initial_dims = 10, max_iter = 100, dims = 3, perplexity = 3, ## tSNE
    min_dist = 0.1, n_neighbors = 15, spread = 1) ## UMAP
tblPCALoadings(x, params)

}
\author{
Thomas Naake
}
