% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{sumDistSample}
\alias{sumDistSample}
\title{Plot the sum of distances to other samples}
\usage{
sumDistSample(d, title = "raw")
}
\arguments{
\item{d}{\code{matrix} containing distances, obtained from \code{distShiny}}

\item{title}{\code{character} specifying the title to be added to the plot}
}
\value{
\code{gg} object from \code{ggplot2}
}
\description{
The function \code{sumDistSample} creates a plot showing the sum of distance 
of a sample to other samples.
}
\examples{
a <- matrix(seq_len(100), nrow = 10, ncol = 10, 
            dimnames = list(seq_len(10), paste("sample", seq_len(10))))
dist <- distShiny(a)

sumDistSample(dist, title = "raw")

}
