% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyQC.R
\name{shinyQC}
\alias{shinyQC}
\title{Shiny application for initial QC exploration of -omics data sets}
\usage{
shinyQC(se, app_server = FALSE)
}
\arguments{
\item{se}{\code{SummarizedExperiment} object (can be omitted)}

\item{app_server}{\code{logical} (set to \code{TRUE} if run under a server 
environment)}
}
\value{
\code{shiny} application, 
\code{SummarizedExperiment} upon exiting the \code{shiny} application
}
\description{
The shiny application allows to explore -omics
data sets especially with a focus on quality control. \code{shinyQC} gives
information on the type of samples included (if this was previously
specified within the \code{SummarizedExperiment} object). It gives 
information on the number of missing and measured values across features 
and across sets (e.g. quality control samples, control, and treatment 
groups, only displayed for \code{SummarizedExperiment} objects that 
contain missing values).

\code{shinyQC} includes functionality to display (count/intensity) values 
across samples (to detect drifts in intensity values during the 
measurement), to display
mean-sd plots, MA plots, ECDF plots, and distance plots between samples.
\code{shinyQC} includes functionality to perform dimensionality reduction
(currently limited to PCA, PCoA, NMDS, tSNE, and UMAP). Additionally,
it includes functionality to perform differential expression analysis
(currently limited to moderated t-tests and the Wald test).
}
\details{
\code{rownames(se)} should be set to the corresponding name of features, 
while \code{colnames(se)} should be set to the sample IDs. 
\code{rownames(se)} and \code{colnames(se)} are not allowed to be NULL.
\code{colnames(se)}, \code{colnames(assay(se))} and 
\code{rownames(colData(se))} all have to be identical.

\code{shinyQC} allows to subset the supplied \code{SummarizedExperiment} object. 

On exit of the shiny application, the (subsetted) \code{SummarizedExperiment} 
object is returned with information on the processing steps (normalization, 
transformation, batch correction and imputation). The object will 
only returned if \code{app_server = FALSE} and if the function call is assigned
to an object, e.g. \code{tmp <- shinyQC(se)}. 

If the \code{se} argument is omitted the app will load an interface that allows 
for data upload.
}
\examples{
library(dplyr)
library(SummarizedExperiment)

## create se
set.seed(1)
a <- matrix(rnorm(100, mean = 10, sd = 2), nrow = 10, ncol = 10, 
            dimnames = list(seq_len(10), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
cD <- data.frame(name = colnames(a), type = c(rep("1", 5), rep("2", 5)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment(assay = a, rowData = rD, colData = cD)

\donttest{shinyQC(se)}

}
\author{
Thomas Naake
}
