% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_samplesfeatures.R
\name{hist_sample}
\alias{hist_sample}
\title{Plot a histogram of the number of a category}
\usage{
hist_sample(tbl, category = "type")
}
\arguments{
\item{tbl}{\code{tbl} as returned by \code{hist_sample_num}}

\item{category}{\code{character}, x-axis label of the plot}
}
\value{
\code{gg} object from \code{ggplot2}
}
\description{
\code{hist_sample} plots the number of a category (e.g. sample types)
as a histogram. It use the returned \code{tbl} from \code{hist_sample_num}.
}
\examples{
## create se
a <- matrix(seq_len(100), nrow = 10, ncol = 10, 
            dimnames = list(seq_len(10), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
set.seed(1)
a <- a + rnorm(100)
cD <- data.frame(name = colnames(a), type = c(rep("1", 4), rep("2", 6)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment::SummarizedExperiment(assay = a, 
    rowData = rD, colData = cD)

tbl <- hist_sample_num(se, category = "type")
hist_sample(tbl)

}
