% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{distShiny}
\alias{distShiny}
\title{Create distance matrix from numerical matrix}
\usage{
distShiny(x, method = "euclidean")
}
\arguments{
\item{x}{\code{matrix} or \code{data.frame} with samples in columns and 
features in rows}

\item{method}{\code{character}, method for distance calculation}
}
\value{
\code{matrix}
}
\description{
The function \code{distShiny} takes as an input a numerical \code{matrix} or
\code{data.frame} and returns the distances between the rows and columns
based on the defined \code{method} (e.g. euclidean distance).
}
\details{
Internal use in \code{shinyQC}.
}
\examples{
x <- matrix(seq_len(100), nrow = 10, ncol = 10, 
        dimnames = list(seq_len(10), paste("sample", seq_len(10))))
distShiny(x = x)

}
