% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_dimensionreduction.R
\name{dimensionReduction}
\alias{dimensionReduction}
\title{Dimensionality reduction with dimensionReduction methods PCA,
PCoA, NMDS, UMAP and tSNE}
\usage{
dimensionReduction(
  x,
  type = c("PCA", "PCoA", "NMDS", "tSNE", "UMAP"),
  params = list()
)
}
\arguments{
\item{x}{\code{matrix}, containing no missing values, samples are in columns 
and features are in rows}

\item{type}{\code{character}, specifying the type/method to use for 
dimensionality reduction. One of \code{PCA}, \code{PCoA}, \code{NMDS}, 
\code{tSNE}, or \code{UMAP}.}

\item{params}{\code{list}, arguments/parameters given to the functions 
\code{stats::prcomp}, \code{stats::dist}, \code{Rtsne::Rtsne}, 
\code{umap::umap}}
}
\value{
list, first entry contains a \code{tbl}, second entry contains
the object returned from \code{prcomp} (PCA), \code{cmdscale} (PCoA),
\code{isoMDS} (NMDS), \code{Rtsne} (tSNE), or \code{umap} (UMAP)
}
\description{
The function \code{dimensionReduction} creates a \code{data.frame} 
with the coordinates of the projected data (first entry of returned output). 
The function allows for the 
following projections:
Principal Component Analysis (PCA), Principal Coordinates 
Analysis/Multidimensional Scaling (PCoA), Non-metric Multidimensional 
scaling (NMDS), t-distributed stochastic neighbor embedding (tSNE), and 
Uniform Manifold Approximation and Projection (UMAP).

The second list entry will contains the object returned from 
\code{prcomp} (PCA), \code{cmdscale} (PCoA), \code{isoMDS} (NMDS), 
\code{Rtsne} (tSNE), or \code{umap} (UMAP).
}
\details{
The function \code{dimensionReduction} is a wrapper around the following 
functions \code{stats::prcomp} (PCA), \code{stats::cmdscale} (PCoA), 
\code{MASS::isoMDS} (NMDS), \code{Rtsne::Rtsne} (tSNE), and 
\code{umap::umap} (UMAP). For the function \code{umap::umap} 
the method is set to \code{naive}.
}
\examples{
x <- matrix(rnorm(seq_len(10000)), ncol = 100)
rownames(x) <- paste("feature", seq_len(nrow(x)))
colnames(x) <- paste("sample", seq_len(ncol(x)))
params <- list(method = "euclidean", ## dist
    initial_dims = 10, max_iter = 100, dims = 3, perplexity = 3, ## tSNE
    min_dist = 0.1, n_neighbors = 15, spread = 1) ## UMAP
dimensionReduction(x, type = "PCA", params = params)
dimensionReduction(x, type = "PCoA", params = params)
dimensionReduction(x, type = "NMDS", params = params)
dimensionReduction(x, type = "tSNE", params = params)
dimensionReduction(x, type = "UMAP", params = params)

}
\author{
Thomas Naake
}
