% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{createDfFeature}
\alias{createDfFeature}
\title{Create data frame of (count/intensity) values for a selected feature
along data processing steps}
\usage{
createDfFeature(l, feature)
}
\arguments{
\item{l}{\code{list} containing matrices at different processing steps}

\item{feature}{\code{character}, element of \code{rownames} of the matrices 
in \code{l}}
}
\value{
\code{data.frame}
}
\description{
The function \code{createDfFeature} takes as input a list of matrices and 
returns the row \code{Feature} of each matrix as a column of a 
\code{data.frame}. The function \code{createDfFeature} provides the input 
for the function \code{featurePlot}.
}
\details{
Internal usage in \code{shinyQC}
}
\examples{
set.seed(1)
x1 <- matrix(rnorm(100), ncol = 10, nrow = 10, 
    dimnames = list(paste("feature", seq_len(10)), 
        paste("sample", seq_len(10))))
x2 <- x1 + 5
x3 <- x2 + 10

l <- list(x1 = x1, x2 = x2, x3 = x3)
createDfFeature(l, "feature 1")

}
