% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_measuredvalues_missingvalues.R
\name{barplotSamplesMeasuredMissing}
\alias{barplotSamplesMeasuredMissing}
\title{Barplot of number of measured/missing features of samples}
\usage{
barplotSamplesMeasuredMissing(tbl, measured = TRUE)
}
\arguments{
\item{tbl}{\code{tbl} object}

\item{measured}{\code{logical}, should the number of measured or missing 
values be plotted}
}
\value{
\code{gg} object from \code{ggplot2}
}
\description{
\code{barplotSamplesMeasuredMissing} plots the number of 
measured/missing features of samples as a barplot. The function will 
take as input the returned \code{tbl} of \code{samplesMeasuredMissing}.
}
\examples{
## create se
a <- matrix(seq_len(100), nrow = 10, ncol = 10, 
            dimnames = list(seq_len(10), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
set.seed(1)
a <- a + rnorm(100)
cD <- data.frame(name = colnames(a), type = c(rep("1", 5), rep("2", 5)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment::SummarizedExperiment(assay = a, 
    rowData = rD, colData = cD)

## create the data.frame with information on number of measured/missing
## values
tbl <- samplesMeasuredMissing(se) 

## plot number of measured values
barplotSamplesMeasuredMissing(tbl, measured = TRUE)

## plot number of missing values
barplotSamplesMeasuredMissing(tbl, measured = FALSE)

}
