% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLocalMaximumCWT.R
\name{getLocalMaximumCWT}
\alias{getLocalMaximumCWT}
\title{Identify the local maximum of each column in 2-D CWT coefficients matrix}
\usage{
getLocalMaximumCWT(
  wCoefs,
  minWinSize = 5,
  amp.Th = 0,
  isAmpThreshRelative = FALSE,
  exclude0scaleAmpThresh = FALSE
)
}
\arguments{
\item{wCoefs}{2-D CWT coefficients, each column corresponding to CWT
coefficient at one scale. The column name is the scale.}

\item{minWinSize}{The minimum slide window size used.}

\item{amp.Th}{The minimum peak amplitude.}

\item{isAmpThreshRelative}{Whether \code{amp.Th} is given relative to
\code{max(wCoefs)}.}

\item{exclude0scaleAmpThresh}{When computing the relative \code{amp.Th}, if
this is set to \code{TRUE}, the \code{amp.Th} will exclude the zero-th scale from the
\code{max(wCoefs)}. The zero-th scale corresponds to the original signal, that may
have a much larger baseline than the wavelet coefficients and can distort the
threshold calculation. The default is \code{FALSE} to preserve backwards compatibility.}
}
\value{
return a matrix with same dimension as CWT coefficient matrix,
wCoefs. The local maxima are marked as 1, others are 0.
}
\description{
Identify the local maximum of each column in 2-D CWT coefficients matrix by
using a slide window. The size of slide window linearly changes from the
coarse scale (bigger window size) to detail scale. The scale of CWT
increases with the column index.
}
\examples{

data(exampleMS)
scales <- seq(1, 64, 3)
wCoefs <- cwt(exampleMS[5000:11000], scales = scales, wavelet = "mexh")

localMax <- getLocalMaximumCWT(wCoefs)
plotLocalMax(localMax)

}
\seealso{
\code{\link[=localMaximum]{localMaximum()}}
}
\author{
Pan Du
}
\keyword{methods}
