% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendNBase.R
\name{extendNBase}
\alias{extendNBase}
\title{Extend the row number of a matrix as the exponential of base N}
\usage{
extendNBase(x, nLevel = 1, base = 2, ...)
}
\arguments{
\item{x}{data matrix}

\item{nLevel}{the level of DWT decomposition. Basically, it is equivalent to
changing the 'base' as base^nLevel}

\item{base}{the base, 2 by default}

\item{\dots}{other parameters of used by \code{\link[=extendLength]{extendLength()}}}
}
\value{
Return a extended matrix
}
\description{
Extend the data as the exponential of base N by increasing row number.
}
\details{
The method 'open' is padding the the matrix with the last row.
}
\examples{
\donttest{
a <- matrix(rnorm(9), 3)
MassSpecWavelet:::extendNBase(a)
}

}
\seealso{
\code{\link[=extendLength]{extendLength()}}
}
\author{
Pan Du
}
\keyword{internal}
