\name{QC_PCA_scoreplot}
\alias{QC_PCA_scoreplot}
\title{PCA score plot}
\description{
This function generates a PCA score plot colored based on sample type (i.e. experimental
or quality control (QC) sample). The plots generated with this function can be used
to assess analytical reproducibility and stability. If the dataset is reproducible,
all quality control samples should appear clustered in the center of the Hotelling's
ellipse.
}
\usage{
QC_PCA_scoreplot (PCA_model, metabo_SE, plot_labels = FALSE,  px = 1, py = 2,
                  CI_level = 0.95, pch = 20, xlim = NULL, ylim = NULL,
                  color_scale = c("cornflowerblue", "red"), grid = TRUE,...)
}
\arguments{
  \item{PCA_model}{"prcomp" object generated by the function "QC_PCA()".}
  \item{metabo_SE}{SummarizedExperiment object. See "MWAS_SummarizedExperiment()".}
  \item{plot_labels}{logical constant indicating whether the sample IDs will be
  displayed in the score plot.}
  \item{px}{numeric value indicating the index of the principal component that
  will be displayed on the x-axis.}
  \item{py}{numeric value indicating the index of the principal component that
  will be displayed on the y-axis.}
  \item{CI_level}{numeric value indicating the confidence interval for the Hotelling's
  ellipse.}
  \item{pch}{value specifying the symbol that will represent each sample in the
  score. To see all possible symbols, check "plot()" options.}
  \item{xlim}{numeric vector containing the minimum and maximum values of the x-axis.}
  \item{ylim}{numeric vector containing the minimum and maximum values of the y-axis.}
  \item{color_scale}{character vector corresponding to the 2-color scale that
  will be used to discriminate the experimental samples from the QC samples.}
  \item{grid}{logical constant indicating whether grid lines will be added to the
  plot.}
  \item{...}{other arguments passed to "plot()".}
}
\value{
A PCA score plot.
}
\references{
Fox J, Weisberg S. (2011). An R Companion to Applied Regression, Second Edition, Sage.

Mardia K, et al. (1979). Multivariate Analysis, London: Academic Press.
}
\examples{
## Load data
data(metabo_SE)

## PCA model
PCA_model <- QC_PCA (metabo_SE)

## PCA score plots
QC_PCA_scoreplot (PCA_model, metabo_SE) # PC1 vs PC2
QC_PCA_scoreplot (PCA_model, metabo_SE, px = 3, py = 4) # PC3 vs PC4
QC_PCA_scoreplot(PCA_model, metabo_SE, plot_labels = TRUE) # show labels
QC_PCA_scoreplot (PCA_model, metabo_SE, CI_level = 0.80) # change CI
}
