\name{MWAS_network}
\alias{MWAS_network}
\title{Visualize MWAS results in a correlation-based metabolic network}
\description{
This function allows visualizing MWAS results in a correlation-based metabolic network.
The network is an undirected graph where the nodes represent the metabolites, and the
edges represent a co-abundance relationship between pairs of nodes. Different node
parameters (e.g. color, size) can be customized based on MWAS results.
}
\usage{
MWAS_network (metabo_SE, MWAS_matrix, alpha_th = 0.05, cor_th = 0.25,
              file_name = "Correlation", res_cor = 2)
}
\arguments{
  \item{metabo_SE}{SummarizedExperiment object. See "MWAS_SummarizedExperiment()".}
  \item{MWAS_matrix}{numeric matrix generated by the function "MWAS_stats()".}
  \item{alpha_th}{numeric value indicating MWAS significance threshold.}
  \item{cor_th}{numeric value indicating the co-abundance similarity threshold.
  Thus, two metabolites will be linked in the network if the absolute correlation
  (Pearson) between them exceeds cor_th.}
  \item{file_name}{character string indicating the name given to the cytoscape files
  that will be exported to the working directory.}
  \item{res_cor}{numeric value restricting the number of decimals of the correlation
  of coefficients used to build the edges of the network.}
}
\references{
Csardi G, Nepusz T. (2006). The igraph software package for complex network
research. InterJournal, Complex Systems, 1695.
}
\value{
A correlation based-metabolic network formalized as a weigthed igraph object. This
igraph object contains two node attributes: "score" and "color". "score" is a vector
containing the MWAS score (-log10(pvalue)*estimate sign) of each metabolite. "color"
is a vector indicating the color of each node based on MWAS results ("cornflowerblue":
"downregulation", "gray":"no change", "firebrick1":"upregulation"). These attributes
can be used to customize node parameters based on MWAS results. The function also
exports a network file ("Correlation_NetworkFile.txt") and an attribute file
("Correlation_AttributeFile.txt") of MWAS scores, which can be imported into
cytoscape to visualize the network.
}
\examples{
## Load data
data(targetMetabo_SE)

## Test for association between diabetes and target_metabolites
T2D_model <- MWAS_stats (targetMetabo_SE, disease_id = "T2D",
                         confounder_ids = c("Age", "Gender", "BMI"),
                         assoc_method = "logistic")

## Build correlation-based metabolic network
net_T2D <- MWAS_network(targetMetabo_SE, T2D_model, file_name = "MWAS_T2D",
                        cor_th = 0.30)

## Visualize network using the igraph package
# library(igraph)
# plot(net_T2D, vertex.size = abs(V(net_T2D)$score*6)) # node size based on scores

# plot(net_T2D, vertex.size = abs(V(net_T2D)$score*6),
#      edge.label = E(net_T2D)$weight) # show edge labels
}
