% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupComparisonQCPlots.R
\name{groupComparisonQCPlots}
\alias{groupComparisonQCPlots}
\title{Visualization for model-based quality control in fitting model}
\usage{
groupComparisonQCPlots(
  data,
  type,
  axis.size = 10,
  dot.size = 3,
  width = 10,
  height = 10,
  which.Protein = "all",
  address = ""
)
}
\arguments{
\item{data}{output from function groupComparison.}

\item{type}{choice of visualization. "QQPlots" represents normal quantile-quantile 
plot for each protein after fitting models. "ResidualPlots" represents a plot
of residuals versus fitted values for each protein in the dataset.}

\item{axis.size}{size of axes labels. Default is 10.}

\item{dot.size}{size of points in the graph for residual plots and QQ plots. Default is 3.}

\item{width}{width of the saved file. Default is 10.}

\item{height}{height of the saved file. Default is 10.}

\item{which.Protein}{Protein list to draw plots. List can be names of Proteins 
or order numbers of Proteins from levels(testResultOneComparison$ComparisonResult$Protein). 
Default is "all", which generates all plots for each protein.}

\item{address}{name that will serve as a prefix to the name of output file.}
}
\value{
produce a pdf file
}
\description{
To check the assumption of linear model for whole plot inference, 
groupComparisonQCPlots takes the results after fitting models from function 
(\code{\link{groupComparison}}) as input and automatically generate two types 
of figures in pdf files as output: 
(1) normal quantile-quantile plot (specify "QQPlot" in option type) for checking
normally distributed errors.; 
(2) residual plot (specify "ResidualPlot" in option type).
}
\details{
Results based on statistical models for whole plot level inference are 
accurate as long as the assumptions of the model are met. The model assumes that 
the measurement errors are normally distributed with mean 0 and constant variance. 
The assumption of a constant variance can be checked by examining the residuals from the model.
\itemize{
\item{QQPlots : a normal quantile-quantile plot for each protein is generated in order to check whether the errors are well approximated by a normal distribution. If points fall approximately along a straight line, then the assumption is appropriate for that protein. Only large deviations from the line are problematic.}
\item{ResidualPlots : The plots of residuals against predicted(fitted) values. If it shows a random scatter, then the assumption is appropriate.}
}
}
\examples{
QuantData <- dataProcess(SRMRawData, use_log_file = FALSE)
head(QuantData$FeatureLevelData)
levels(QuantData$FeatureLevelData$GROUP)
comparison <- matrix(c(-1,0,0,0,0,0,1,0,0,0),nrow=1)
row.names(comparison) <- "T7-T1"
colnames(comparison) <- unique(QuantData$ProteinLevelData$GROUP)
# Tests for differentially abundant proteins with models:
# label-based SRM experiment with expanded scope of biological replication.
testResultOneComparison <- groupComparison(contrast.matrix=comparison, data=QuantData,
use_log_file = FALSE)
# normal quantile-quantile plots
groupComparisonQCPlots(data=testResultOneComparison, type="QQPlots", address="")
# residual plots
groupComparisonQCPlots(data=testResultOneComparison, type="ResidualPlots", address="")

}
