% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataProcessPlots.R
\name{dataProcessPlots}
\alias{dataProcessPlots}
\title{Visualization for explanatory data analysis}
\usage{
dataProcessPlots(
  data,
  type,
  featureName = "Transition",
  ylimUp = FALSE,
  ylimDown = FALSE,
  scale = FALSE,
  interval = "CI",
  x.axis.size = 10,
  y.axis.size = 10,
  text.size = 4,
  text.angle = 0,
  legend.size = 7,
  dot.size.profile = 2,
  dot.size.condition = 3,
  width = 800,
  height = 600,
  which.Protein = "all",
  originalPlot = TRUE,
  summaryPlot = TRUE,
  save_condition_plot_result = FALSE,
  remove_uninformative_feature_outlier = FALSE,
  address = "",
  isPlotly = FALSE
)
}
\arguments{
\item{data}{name of the (output of dataProcess function) data set.}

\item{type}{choice of visualization. "ProfilePlot" represents profile plot of 
log intensities across MS runs. "QCPlot" represents quality control plot of 
log intensities across MS runs. "ConditionPlot" represents mean plot of log 
ratios (Light/Heavy) across conditions.}

\item{featureName}{for "ProfilePlot" only, "Transition" (default) means 
printing feature legend in transition-level; "Peptide" means printing feature 
legend in peptide-level; "NA" means no feature legend printing.}

\item{ylimUp}{upper limit for y-axis in the log scale. FALSE(Default) for 
Profile Plot and QC Plot use the upper limit as rounded off maximum of 
log2(intensities) after normalization + 3. FALSE(Default) for Condition Plot
is maximum of log ratio + SD or CI.}

\item{ylimDown}{lower limit for y-axis in the log scale. FALSE(Default) for 
Profile Plot and QC Plot is 0. FALSE(Default) for Condition Plot is minumum
of log ratio - SD or CI.}

\item{scale}{for "ConditionPlot" only, FALSE(default) means each conditional 
level is not scaled at x-axis according to its actual value (equal space at 
x-axis). TRUE means each conditional level is scaled at x-axis according to
its actual value (unequal space at x-axis).}

\item{interval}{for "ConditionPlot" only, "CI"(default) uses confidence 
interval with 0.95 significant level for the width of error bar. 
"SD" uses standard deviation for the width of error bar.}

\item{x.axis.size}{size of x-axis labeling for "Run" in Profile Plot and 
QC Plot, and "Condition" in Condition Plot. Default is 10.}

\item{y.axis.size}{size of y-axis labels. Default is 10.}

\item{text.size}{size of labels represented each condition at the top of 
graph in Profile Plot and QC plot. Default is 4.}

\item{text.angle}{angle of labels represented each condition at the top
of graph in Profile Plot and QC plot or x-axis labeling in Condition plot. 
Default is 0.}

\item{legend.size}{size of feature legend (transition-level or peptide-level)
above graph in Profile Plot. Default is 7.}

\item{dot.size.profile}{size of dots in profile plot. Default is 2.}

\item{dot.size.condition}{size of dots in condition plot. Default is 3.}

\item{width}{width of the saved file in pixels. Default is 800 pixels.}

\item{height}{height of the saved file in pixels. Default is 600 pixels.}

\item{which.Protein}{Protein list to draw plots. List can be names of Proteins
or order numbers of Proteins from levels(data$FeatureLevelData$PROTEIN).
Default is "all", which generates all plots for each protein. 
For QC plot, "allonly" will generate one QC plot with all proteins.}

\item{originalPlot}{TRUE(default) draws original profile plots.}

\item{summaryPlot}{TRUE(default) draws profile plots with 
summarization for run levels.}

\item{save_condition_plot_result}{TRUE saves the table with values 
using condition plots. Default is FALSE.}

\item{remove_uninformative_feature_outlier}{It only works after users used 
featureSubset="highQuality" in dataProcess. TRUE allows to remove
1) the features are flagged in the column, feature_quality="Uninformative" 
which are features with bad quality, 
2) outliers that are flagged in the column, is_outlier=TRUE in Profile plots. 
FALSE (default) shows all features and intensities in profile plots.}

\item{address}{prefix for the filename that will store the results.}

\item{isPlotly}{Parameter to use Plotly or ggplot2. If set to TRUE, MSstats 
will save Plotly plots as HTML files. If set to FALSE MSstats will save ggplot2 plots
as PDF files
Default folder is the current working directory. 
The other assigned folder has to be existed under the current working directory.
 An output pdf file is automatically created with the default name of 
 "ProfilePlot.pdf" or "QCplot.pdf" or "ConditionPlot.pdf" or "ConditionPlot_value.csv". 
 The command address can help to specify where to store the file as well as 
 how to modify the beginning of the file name. 
 If address=FALSE, plot will be not saved as pdf file but showed in window.}
}
\description{
To illustrate the quantitative data after data-preprocessing and 
quality control of MS runs, dataProcessPlots takes the quantitative data from 
function (\code{\link{dataProcess}}) as input and automatically generate 
three types of figures in pdf files as output : 
(1) profile plot (specify "ProfilePlot" in option type), 
to identify the potential sources of variation for each protein; 
(2) quality control plot (specify "QCPlot" in option type), 
to evaluate the systematic bias between MS runs; 
(3) mean plot for conditions (specify "ConditionPlot" in option type), 
to illustrate mean and variability of each condition per protein.
}
\details{
\itemize{
\item{Profile Plot : identify the potential sources of variation of each protein. QuantData$FeatureLevelData is used for plots. X-axis is run. Y-axis is log-intensities of transitions. Reference/endogenous signals are in the left/right panel. Line colors indicate peptides and line types indicate transitions. In summarization plots, gray dots and lines are the same as original profile plots with QuantData$FeatureLevelData. Dark dots and lines are for summarized intensities from QuantData$ProteinLevelData.}
\item{QC Plot : illustrate the systematic bias between MS runs. After normalization, the reference signals for all proteins should be stable across MS runs. QuantData$FeatureLevelData is used for plots. X-axis is run. Y-axis is log-intensities of transition. Reference/endogenous signals are in the left/right panel. The pdf file contains (1) QC plot for all proteins and (2) QC plots for each protein separately.}
\item{Condition Plot : illustrate the systematic difference between conditions. Summarized intensnties from QuantData$ProteinLevelData are used for plots. X-axis is condition. Y-axis is summarized log transformed intensity. If scale is TRUE, the levels of conditions is scaled according to its actual values at x-axis. Red points indicate the mean for each condition. If interval is "CI", blue error bars indicate the confidence interval with 0.95 significant level for each condition. If interval is "SD", blue error bars indicate the standard deviation for each condition.The interval is not related with model-based analysis.}
}
The input of this function is the quantitative data from function \code{\link{dataProcess}}.
}
\examples{
# Consider quantitative data (i.e. QuantData) from a yeast study with ten time points of interests, 
# three biological replicates, and no technical replicates which is a time-course experiment. 
# The goal is to provide pre-analysis visualization by automatically generate two types of figures 
# in two separate pdf files. 
# Protein IDHC (gene name IDP2) is differentially expressed in time point 1 and time point 7, 
# whereas, Protein PMG2 (gene name GPM2) is not.

QuantData<-dataProcess(SRMRawData, use_log_file = FALSE)
head(QuantData$FeatureLevelData)
# Profile plot
dataProcessPlots(data=QuantData,type="ProfilePlot")
# Quality control plot 
dataProcessPlots(data=QuantData,type="QCPlot")	
# Quantification plot for conditions
dataProcessPlots(data=QuantData,type="ConditionPlot")

}
