% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDRFconverter.R
\name{SDRFtoAnnotation}
\alias{SDRFtoAnnotation}
\title{Convert SDRF experimental design file into an MSstats annotation file}
\usage{
SDRFtoAnnotation(
  data,
  run_name = "comment[data file]",
  condition_name = "characteristics[disease]",
  biological_replicate = "characteristics[biological replicate]",
  fraction = NULL
)
}
\arguments{
\item{data}{SDRF annotation file}

\item{run_name}{Column name in SDRF file which contains the name of the MS 
run. The information in this column must match exactly with the run names in
the PSM file}

\item{condition_name}{Column name in SDRF file which contains information on 
the conditions in the data.}

\item{biological_replicate}{Column name in SDRF file which contains the 
identifier for the biological replicte. Note MSstats uses this column to 
determine if the experiment is a repeated measure design. BioReplicte IDs 
should only be reused if the replicate was measured multiple times.}

\item{fraction}{Column name in SDFT file which contains information on the 
fractionation in the data. Only required if data contains fractions. Default 
is `NULL`}
}
\description{
Takes an SDRF file and outputs an MSstats annotation file. Note
the information in the SDRF file must be correctly annotated for MSstats so 
that MSstats can identify the experimental design. In particular the 
biological replicates must be correctly annotated, with group comparison 
experiments having a unique ID for each BioReplicate. For more information 
on this please see the Supplementary of the most recent  
\href{https://pubs.acs.org/doi/10.1021/acs.jproteome.2c00834}{MSstats paper}
}
\examples{
head(example_SDRF)

msstats_annotation = SDRFtoAnnotation(example_SDRF)

head(msstats_annotation)
}
