% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataProcess.R
\name{MSstatsSummarizeSingleTMP}
\alias{MSstatsSummarizeSingleTMP}
\title{Tukey Median Polish summarization for a single protein}
\usage{
MSstatsSummarizeSingleTMP(
  single_protein,
  impute,
  censored_symbol,
  remove50missing,
  aft_iterations = 90
)
}
\arguments{
\item{single_protein}{feature-level data for a single protein}

\item{impute}{only for summaryMethod = "TMP" and censoredInt = 'NA' or '0'. 
TRUE (default) imputes 'NA' or '0' (depending on censoredInt option) by Accelated failure model. 
FALSE uses the values assigned by cutoffCensored}

\item{censored_symbol}{Missing values are censored or at random. 
'NA' (default) assumes that all 'NA's in 'Intensity' column are censored. 
'0' uses zero intensities as censored intensity. 
In this case, NA intensities are missing at random. 
The output from Skyline should use '0'. 
Null assumes that all NA intensites are randomly missing.}

\item{remove50missing}{only for summaryMethod = "TMP". TRUE removes the proteins 
where every run has at least 50\% missing values for each peptide. FALSE is default.}

\item{aft_iterations}{number of iterations for AFT model fitting}
}
\value{
list of two data.tables: one with fitted survival model,
the other with protein-level data
}
\description{
Tukey Median Polish summarization for a single protein
}
\examples{
raw = DDARawData 
method = "TMP"
cens = "NA"
impute = TRUE 
# currently, MSstats only supports MBimpute = FALSE for linear summarization
MSstatsConvert::MSstatsLogsSettings(FALSE)
input = MSstatsPrepareForDataProcess(raw, 2, NULL)
input = MSstatsNormalize(input, "EQUALIZEMEDIANS")
input = MSstatsMergeFractions(input)
input = MSstatsHandleMissing(input, "TMP", TRUE, "NA", 0.999)
input = MSstatsSelectFeatures(input, "all")
input = MSstatsPrepareForSummarization(input, method, impute, cens, FALSE)
input_split = split(input, input$PROTEIN)
single_protein_summary = MSstatsSummarizeSingleTMP(input_split[[1]],
                                                   impute, cens, FALSE, 100)
head(single_protein_summary[[1]])

}
