% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_output.R
\name{MSstatsSummarizationOutput}
\alias{MSstatsSummarizationOutput}
\title{Post-processing output from MSstats summarization}
\usage{
MSstatsSummarizationOutput(
  input,
  summarized,
  processed,
  method,
  impute,
  censored_symbol
)
}
\arguments{
\item{input}{`data.table` in MSstats format}

\item{summarized}{output of the `MSstatsSummarizeWithSingleCore` function}

\item{processed}{output of MSstatsSelectFeatures}

\item{method}{name of the summarization method
(`summaryMethod` parameter to `dataProcess`)}

\item{impute}{if TRUE, censored missing values were imputed
(`MBimpute` parameter to `dataProcess`)}

\item{censored_symbol}{censored missing value indicator 
(`censoredInt` parameter to `dataProcess`)}
}
\value{
A list with the following elements:
  \item{FeatureLevelData}{Feature-level data after processing.}
  \item{ProteinLevelData}{Protein-level (summarized) data.}
  \item{SummaryMethod}{String: name of the summarization method used.}
}
\description{
Post-processing output from MSstats summarization
}
\examples{
raw = DDARawData 
method = "TMP"
cens = "NA"
impute = TRUE
MSstatsConvert::MSstatsLogsSettings(FALSE)
input = MSstatsPrepareForDataProcess(raw, 2, NULL)
input = MSstatsNormalize(input, "EQUALIZEMEDIANS")
input = MSstatsMergeFractions(input)
input = MSstatsHandleMissing(input, "TMP", TRUE, "NA", 0.999)
input = MSstatsSelectFeatures(input, "all")
processed = getProcessed(input)
input = MSstatsPrepareForSummarization(input, method, impute, cens, FALSE)
summarized = MSstatsSummarizeWithSingleCore(input, method, impute, cens, FALSE, TRUE, 100)
output = output = MSstatsSummarizationOutput(input, summarized, processed,
method, impute, cens)

}
