% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupComparison.R
\name{MSstatsGroupComparison}
\alias{MSstatsGroupComparison}
\title{Group comparison}
\usage{
MSstatsGroupComparison(
  summarized_list,
  contrast_matrix,
  save_fitted_models,
  repeated,
  samples_info,
  numberOfCores = 1
)
}
\arguments{
\item{summarized_list}{output of MSstatsPrepareForGroupComparison}

\item{contrast_matrix}{contrast matrix}

\item{save_fitted_models}{if TRUE, fitted models will be included in the output}

\item{repeated}{logical, output of checkRepeatedDesign function}

\item{samples_info}{data.table, output of getSamplesInfo function}

\item{numberOfCores}{Number of cores for parallel processing. When > 1, 
a logfile named `MSstats_groupComparison_log_progress.log` is created to 
track progress. Only works for Linux & Mac OS.}
}
\description{
Group comparison
}
\examples{
QuantData <- dataProcess(SRMRawData, use_log_file = FALSE)
group_comparison_input = MSstatsPrepareForGroupComparison(QuantData)
levels(QuantData$ProteinLevelData$GROUP)
comparison <- matrix(c(-1,0,0,0,0,0,1,0,0,0),nrow=1)
row.names(comparison) <- "T7-T1"
groups = levels(QuantData$ProteinLevelData$GROUP)
colnames(comparison) <- groups[order(as.numeric(groups))]
samples_info = getSamplesInfo(QuantData)
repeated = checkRepeatedDesign(QuantData)
group_comparison = MSstatsGroupComparison(group_comparison_input, comparison,
                                          FALSE, repeated, samples_info)
length(group_comparison) # list of length equal to number of proteins
group_comparison[[1]][[1]] # data used to fit linear model
group_comparison[[1]][[2]] # comparison result
group_comparison[[2]][[3]] # NULL, because we set save_fitted_models to FALSE

}
