% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_calculations.R
\name{tmt_model}
\alias{tmt_model}
\title{Main TMT modeling function for MSstatsShiny application}
\usage{
tmt_model(data, input, contrast.matrix, busy_indicator = TRUE)
}
\arguments{
\item{data}{summarized data from output of MSstats summarization function.}

\item{input}{options for data processing input by the user}

\item{contrast.matrix}{contrast matrix specifying which conditions should be compared}

\item{busy_indicator}{Boolean indicator indicating whether or not to display
shiny waiting indicator.}
}
\value{
list of TMT modeling results
}
\description{
Main TMT function to model MSstatsShiny data.
}
\examples{
data(raw.pd, package = "MSstatsTMT")
data(annotation.pd, package = "MSstatsTMT")

testdata <- MSstatsTMT::PDtoMSstatsTMTFormat(raw.pd, 
                                             annotation.pd,
                                             use_log_file = FALSE
                                             )#' 

qc_input = list()
loadpage_input = list()
qc_input$summarization = "msstats"
qc_input$norm = "equalizeMedians"
qc_input$log = 2
qc_input$names = NULL
qc_input$features_used	= "all"
code_n_feat=3
qc_input$censInt = "NA"
qc_input$MBi = TRUE
qc_input$remove50 = FALSE
qc_input$maxQC = 0.999
qc_input$null = FALSE
qc_input$null1 = FALSE
loadpage_input$DDA_DIA = "LF"
qc_input$global_norm = TRUE
qc_input$reference_norm = TRUE
qc_input$remove_norm_channel = TRUE
qc_input$maxQC1 = NULL
qc_input$moderated = FALSE
qc_input$summaryMethod = "TMP"
summarization_tmt_test = tmt_summarization_loop(testdata, qc_input, loadpage_input,
                                               busy_indicator = FALSE)
                                               
comparison=matrix(c(-1,0,0,1),nrow=1)
row.names(comparison) = "1-0.125"
colnames(comparison) = c("0.125", "0.5", "0.667", "1")

model_tmt_test = tmt_model(summarization_tmt_test, qc_input, comparison, 
                           busy_indicator = FALSE)

}
