% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RiverPlot.R
\name{RiverPlot}
\alias{RiverPlot}
\title{A function to create river plot to aggregate results from X and mR charts or CUSUMm and CUSUMv charts.}
\usage{
RiverPlot(
  data = NULL,
  L = 1,
  U = 5,
  method = "XmR",
  listMean = NULL,
  listSD = NULL
)
}
\arguments{
\item{data}{omma-separated (.csv), metric file. It should contain a "Precursor" column and the metrics columns. It should also include "Annotations" for each observation.}

\item{L}{lower bound of the guide set.}

\item{U}{upper bound of the guide set.}

\item{method}{defines the method selected to construct control charts.}

\item{listMean}{list of the means for each metric. It is used when mean is known. It is NULL when mean is not known.  The default is NULL.}

\item{listSD}{list of the standard deviations for each metric. It is used when standard deviation is known. It is NULL when mean is not known. The default is NULL.}
}
\value{
A river plot to aggregate results per metric generated from \code{XmR.Summary.DataFrame} data frame or \code{CUSUM.Summary.DataFrame} data frame.
}
\description{
A function to create river plot to aggregate results from X and mR charts or CUSUMm and CUSUMv charts.
}
\examples{
# First process the data to make sure it's ready to use
sampleData <- DataProcess(S9Site54)
head(sampleData)
# Draw XmR summary plot
RiverPlot(data = sampleData)
RiverPlot(data = sampleData, L=1, U=20, method = "XmR",
                listMean = list("BestRetentionTime" = 27.78,
                                "TotalArea" = 35097129,
                                 "MaxFWHM" = 0.28,
                                 "MinStartTime" = 24),
                listSD = list("BestRetentionTime" = 8.19,
                              "TotalArea" = 34132861,
                              "MaxFWHM" = 0.054,
                              "MinStartTime" = 24)
                )
}
\keyword{XmR}
