% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing-data.R
\name{naplot}
\alias{naplot}
\title{Overview of missing value}
\usage{
naplot(
  object,
  verbose = isMSnbaseVerbose(),
  reorderRows = TRUE,
  reorderColumns = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{MSnSet}.}

\item{verbose}{If verbose (default is \code{isMSnbaseVerbose()}), print a
table of missing values.}

\item{reorderRows}{If reorderRows (default is \code{TRUE}) rows are ordered
by number of NA.}

\item{reorderColumns}{If reorderColumns (default is \code{TRUE}) columns
are ordered by number of NA.}

\item{...}{Additional parameters passed to \code{image2}.}
}
\value{
Used for its side effect. Invisibly returns \code{NULL}
}
\description{
Visualise missing values as a heatmap and barplots along the
samples and features.
}
\examples{
data(naset)
naplot(naset)
}
\author{
Laurent Gatto
}
